/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260.DeviceView;

import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm8260.DeviceView.Port;
import ibm.nways.jdm8260.MibInfo;
import ibm.nways.jdm8260.MibValue;
import ibm.nways.ras.RAS;
import java.io.Serializable;

public class PortLS
extends Port {
    protected String macAddress;
    protected int mauIndex;

    public PortLS(int n) {
        this.mauIndex = n;
    }

    public void setSpecificInformation() {
        String string;
        this.macAddress = "";
        MibInfo mibInfo = this.hub.getMibInfo();
        Serializable serializable = mibInfo.getVar("ocBridgePortAddr", string = "." + this.slot + "." + this.portNumber);
        if (serializable instanceof MibValue) {
            this.macAddress = ((MibValue)serializable).getValue().toString();
        }
    }

    public ModelInfo getModelInfo() {
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.SlotIndex", new Integer(this.slot));
        modelInfo.add("Index.PortIndex", new Integer(this.portNumber));
        modelInfo.add("Index.MauIndex", new Integer(this.mauIndex));
        return modelInfo;
    }

    public I18NMsgFormat getFlyOverText() {
        String string = "getFlyOverText";
        Object[] objectArray = new Object[4];
        objectArray[0] = new Integer(this.portNumber);
        objectArray[1] = new Integer(this.mauIndex);
        String string2 = "Port_unspecified_conn";
        try {
            string2 = Port.PORT_TYPE[this.portType];
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Cannot find fly-over for port type -> " + this.portType);
            }
            RAS.logException(19, 2, this, string, exception);
        }
        objectArray[2] = this.hub.getBundle().getString(string2);
        objectArray[3] = this.macAddress;
        return new I18NMsgFormat("ibm.nways.jdm8260.DeviceView.GraphicResources", "PortLSWithMac", objectArray);
    }

    protected int getPortNetwork(int n) {
        return n;
    }
}

